--[[
    ╔════════════════════════════════════════════════════════════════════╗
    ║               MuFC Event Script - MuOrbital Season 4               ║
    ║════════════════════════════════════════════════════════════════════║
    ║ Criado por: Mineiro MuOnline                                       ║
    ║ Site: https://youtube.com/@mineiromuonline                         ║
    ║ 						                         ║
    ║ Emulador: Rox Gaming - MuOnline Developer                          ║
    ║ Site: https://roxgaming.net 		                         ║
    ║ 				 		                         ║
    ║ Descrição: Script para o evento MuFC, um torneio PvP com suporte   ║
    ║ a diferentes classes, configurações automáticas e premiações.      ║
    ╚════════════════════════════════════════════════════════════════════╝
--]]

MUFC_CONFIG = {
MUFC_SWITCH = 0,                    		-- Event Ativo: 0 = desabilitado, 1 = habilitado
COMMAND_OPEN = "/abrirpvp",       		-- Comando para abrir manualmente o evento /abrirmufc index (1, 2, 3...)
COMMAND_CANCEL = "/cancelarpvp",  		-- Comando para cancelar o evento
COMMAND_JOIN = "/irpvp",       			-- Comando para os players entrarem no evento
JOIN_TIME = 180,                  		-- Tempo em segundos que o comando ficará disponível
REMAIN_TIME_MESSAGE = 10,			-- Tempo em segundos que irá repetir comando e tempo no global
WAITING_ROOM = {MAP = 6, X = 51, Y = 217}, 	-- Area de espera (recomendado uma SafeZone)
BATTLE_AREA = { MAP = 6, X = 18, Y = 165}, 	-- Area de Combate 1x1 (recomendado uma área onde jogadores não podem ir sozinhos)   
MIN_USERS = 4,  				-- Quantidade de mínima de usuários para o evento acontecer
ROUNDS = 3,  					-- Quantidade de rounds por x1
MINIMUM_LEVEL = 400,				-- Level Mínimo para participar do Evento
BK_DISABLED_SHIELD = 1, 	   	        -- Bloqueio de Shield no BK (1 = Nao entra com Shield / se Equipar no Evento é desclassificado)
BLOCK_ITEM_VISUAL = 0,              		-- Bloqueio de Itens Visuais (1 = Nao entra com Itens Visuais / se Equipar no Evento é desclassificado)
REMOVE_BUFFS = 1,              			-- Remove Buffs ao entrar no Evento

-- Área de configuração dos eventos
-- INDEX:
--	Indes do evento, sempre em ordem crescente sem pular, o comando será usado via index: ex: /abrirmufc 1 (abre o evento de index 1)
-- DAY_OF_MONTH = Dia do Mês, DAY_OF_WEEK = Dia da Semana (1 Seg, 2 Ter,...), HOUR = Hora, MINUTE = Minuto, ANNOUNCE_TIME = Anuncio em minutos (ex: MuFC SM X SM começa em 5 minutos)
-- Class:
--     -1 = "All Classes",
--	0 = "Dark Wizard (DW)",
--	1 = "Dark Knight (DK)",
--	2 = "Fairy Elf (FE)",
--	3 = "Magic Gladiator (MG)",
--	4 = "Dark Lord (DL)",
--	5 = "Summoner (SU)",
--	6 = "Rage Fighter (RF)"
AUTO_START = {
    {INDEX = 1, NAME = "MuFC ELF x ELF", DAY_OF_MONTH = -1, DAY_OF_WEEK = 1, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 2},
    {INDEX = 2, NAME = "MuFC MG x MG", DAY_OF_MONTH = -1, DAY_OF_WEEK = 2, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 3},
    {INDEX = 3, NAME = "MuFC SUM x SUM", DAY_OF_MONTH = -1, DAY_OF_WEEK = 3, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 5},
    {INDEX = 4, NAME = "MuFC DL x DL", DAY_OF_MONTH = -1, DAY_OF_WEEK = 4, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 4},
    {INDEX = 5, NAME = "MuFC SM x SM", DAY_OF_MONTH = -1, DAY_OF_WEEK = 5, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 0},
    {INDEX = 6, NAME = "MuFC BM x BM", DAY_OF_MONTH = -1, DAY_OF_WEEK = 6, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = 1},
    {INDEX = 7, NAME = "Rei do PvP", DAY_OF_MONTH = -1, DAY_OF_WEEK = 0, HOUR = 20, MINUTE = 30, ANNOUNCE_TIME = 5, CLASS = -1},
},

-- Área de configuração das premiações
REWARDS_BY_INDEX = {
-- MuFC - ELF
    [1] = {
        {Section = 4, ID = 186, Quantity = 1, ItemName = "MuFC Bow"},
        {Section = 7, ID = 192, Quantity = 1, ItemName = "MuFC [ELF] Helm"},
        {Section = 8, ID = 192, Quantity = 1, ItemName = "MuFC [ELF] Armor"},
        {Section = 9, ID = 192, Quantity = 1, ItemName = "MuFC [ELF] Pants"},
        {Section = 10, ID = 192, Quantity = 1, ItemName = "MuFC [ELF] Gloves"},
        {Section = 11, ID = 192, Quantity = 1, ItemName = "MuFC [ELF] Boots"}
    },
-- MuFC - MG
    [2] = {
        {Section = 0, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Sword"},
        {Section = 7, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Helm"},
        {Section = 8, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Armor"},
        {Section = 9, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Pants"},
        {Section = 10, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Gloves"},
        {Section = 11, ID = 190, Quantity = 1, ItemName = "MuFC [MG] Boots"}
    },
-- MuFC - SUM
    [3] = {
        {Section = 5, ID = 187, Quantity = 1, ItemName = "MuFC Stick"},
        {Section = 6, ID = 186, Quantity = 1, ItemName = "MuFC Shield"},
        {Section = 7, ID = 193, Quantity = 1, ItemName = "MuFC [SUM] Helm"},
        {Section = 8, ID = 193, Quantity = 1, ItemName = "MuFC [SUM] Armor"},
        {Section = 9, ID = 193, Quantity = 1, ItemName = "MuFC [SUM] Pants"},
        {Section = 10, ID = 193, Quantity = 1, ItemName = "MuFC [SUM] Gloves"},
        {Section = 11, ID = 193, Quantity = 1, ItemName = "MuFC [SUM] Boots"}
    },
-- MuFC - DL
    [4] = {
        {Section = 2, ID = 186, Quantity = 1, ItemName = "MuFC Scepter"},
	{Section = 6, ID = 186, Quantity = 1, ItemName = "MuFC Shield"},
        {Section = 7, ID = 191, Quantity = 1, ItemName = "MuFC [DL] Helm"},
        {Section = 8, ID = 191, Quantity = 1, ItemName = "MuFC [DL] Armor"},
        {Section = 9, ID = 191, Quantity = 1, ItemName = "MuFC [DL] Pants"},
        {Section = 10, ID = 191, Quantity = 1, ItemName = "MuFC [DL] Gloves"},
        {Section = 11, ID = 191, Quantity = 1, ItemName = "MuFC [DL] Boots"}
    },
-- MuFC - SM
    [5] = {
        {Section = 5, ID = 186, Quantity = 1, ItemName = "MuFC [SM] Staff"},
        {Section = 6, ID = 186, Quantity = 1, ItemName = "MuFC Shield"},
        {Section = 7, ID = 189, Quantity = 1, ItemName = "MuFC [SM] Helm"},
        {Section = 8, ID = 189, Quantity = 1, ItemName = "MuFC [SM] Armor"},
        {Section = 9, ID = 189, Quantity = 1, ItemName = "MuFC [SM] Pants"},
        {Section = 10, ID = 189, Quantity = 1, ItemName = "MuFC [SM] Gloves"},
        {Section = 11, ID = 189, Quantity = 1, ItemName = "MuFC [SM] Boots"}
    },
-- MuFC - BM
    [6] = {
        {Section = 0, ID = 189, Quantity = 1, ItemName = "MuFC [BK] Sword"},
        {Section = 7, ID = 188, Quantity = 1, ItemName = "MuFC [BK] Helm"},
        {Section = 8, ID = 188, Quantity = 1, ItemName = "MuFC [BK] Armor"},
        {Section = 9, ID = 188, Quantity = 1, ItemName = "MuFC [BK] Pants"},
        {Section = 10, ID = 188, Quantity = 1, ItemName = "MuFC [BK] Gloves"},
        {Section = 11, ID = 188, Quantity = 1, ItemName = "MuFC [BK] Boots"}
    },
-- Rei do PvP - All Classes
    [7] = {
        {Section = 0, ID = 143, Quantity = 1, ItemName = "King of PvP Sword"},
        {Section = 2, ID = 143, Quantity = 1, ItemName = "King of PvP Scepter"},
        {Section = 4, ID = 143, Quantity = 1, ItemName = "King of PvP Bow"},
        {Section = 5, ID = 143, Quantity = 1, ItemName = "King of PvP Staff"},
        {Section = 6, ID = 143, Quantity = 1, ItemName = "King of PvP Shield"},
        {Section = 7, ID = 146, Quantity = 1, ItemName = "King of PvP Helm"},
        {Section = 8, ID = 146, Quantity = 1, ItemName = "King of PvP Armor"},
        {Section = 9, ID = 146, Quantity = 1, ItemName = "King of PvP Pants"},
        {Section = 10, ID = 146, Quantity = 1, ItemName = "King of PvP Gloves"},
        {Section = 11, ID = 146, Quantity = 1, ItemName = "King of PvP Boots"}
    }
},
  
-- MENSAGENS
MESSAGES = {
    COUNTDOWN_ANNOUNCE = "O Evento [ %s ] começará em %d minutos!",
    OPEN_ANNOUNCE1 = "[ %s ] - ABERTO",
    OPEN_ANNOUNCE = "%s PARA ENTRAR. Tempo restante: %d segundos",
    JOIN_PLAYER = "[ %s ] - Player %s adicionado",
    START_ANNOUNCE = "[ %s ] - está iniciado!",
    MATCH_ANNOUNCE = "[ %s ] - Duelo: [ %s ] X [ %s ]",
    BUFF_MESSAGE = "[ %s ] - Buffem seus personagens!",
    PREPARE_MESSAGE = "[ %s ] - Preparem-se para a contagem!",
    COUNTDOWN = "[ %s ] - Contagem: %d...",
    FIGHT_MESSAGE = "[ %s ] - Ataquem-se! GOOOOOOOOOOOOOOO!",
    SCORE_MESSAGE = "[ %s ] - Placar: %s (%d) X (%d) %s",
    MATCH_WINNER = "[ %s ] - %s venceu a partida!",
    FINAL_WINNER = "[ %s ] - %s venceu o [ %s ]! Derrotou: %d oponentes",
    NOT_ENOUGH_PLAYERS = "[ %s ] - Evento cancelado: número insuficiente de jogadores",
    COMMAND_CLOSED = "[ %s ] - Comando de entrada fechado",
    CLASS_RESTRICTED = "[ %s ] - Este evento é apenas para %s",
    EVENT_NOT_FOUND = "Evento não encontrado",
    EVENT_STARTED = "Evento %d (%s) iniciado com sucesso!",
    REWARD_MESSAGE = "[ %s ] - [ %s ] recebeu um [ %s ]!",
    EVENT_CANCELED = "[ %s ] O evento foi cancelado por um GM!",
    NO_EVENT_TO_CANCEL = "Não há nenhum evento em andamento para cancelar",
    LEVEL_TOO_LOW = "[ %s ] - Você precisa ter Level %d para participar!",
  }
}